#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QTextEdit>
#include <QAction>
#include <QStatusBar>
#include <QLabel>
#include <QProcess>

#include "CodeEditor.h"

class MainWindow : public QMainWindow {
    Q_OBJECT
private:
    QAction        *actFileOpen;
    QAction        *actFileExit;
    QAction        *actTaskRun;
    QAction        *actHelpQt;
    CodeEditor     *codeEditor;
    QStatusBar     *statusBar;
    QLabel         *cursorPosLabel;
    QProcess       *process;
public:
    MainWindow(QWidget *parent = NULL);
    ~MainWindow();
private:
    void initActions();
    void initMenu();
    void initCodeEditor();
    void initStatusBar();
    void initProcess();
private slots:
    void onMenuFileOpen();
    void onMenuFileExit();
    void onMenuTaskRun();
    void onMenuHelpQt();

    void onCursorPositionChanged();

    void onProcessStarted();
    void onProcessFinished(int, QProcess::ExitStatus);
    void onReadStandardOutput();
 };
#endif // MAINWINDOW_H
