#include "MainWindow.h"

#include <QMenu>
#include <QMenuBar>
#include <QMessageBox>
#include <QFileDialog>

MainWindow::MainWindow(QWidget *parent) : QMainWindow(parent) {
    setWindowTitle("KRPO_Lab_0x06");
    resize(800, 600);

    initActions();
    initMenu();
    initStatusBar();
    initCodeEditor();
    initProcess();
}

MainWindow::~MainWindow() {
}

void MainWindow::initActions() {
    // Menu "File"
    actFileOpen = new QAction("&Open", this);
    connect(actFileOpen, SIGNAL(triggered()), this, SLOT(onMenuFileOpen()));
    actFileExit = new QAction("&Exit", this);
    connect(actFileExit, SIGNAL(triggered()), this, SLOT(onMenuFileExit()));

    // Menu "Task"
    actTaskRun = new QAction("&Run", this);
    connect(actTaskRun, SIGNAL(triggered()), this, SLOT(onMenuTaskRun()));

    // Menu "Help"
    actHelpQt = new QAction("About &Qt", this);
    connect(actHelpQt, SIGNAL(triggered()), this, SLOT(onMenuHelpQt()));
}

void MainWindow::initMenu() {
    QMenu *menuFile = new QMenu("&File");
    menuFile->addAction(actFileOpen);
    menuFile->addSeparator();
    menuFile->addAction(actFileExit);

    QMenu *menuTask = new QMenu("&Task");
    menuTask->addAction(actTaskRun);

    QMenu *menuHelp = new QMenu("&Help");
    menuHelp->addAction(actHelpQt);

    menuBar()->addMenu(menuFile);
    menuBar()->addMenu(menuTask);
    menuBar()->addMenu(menuHelp);
}

void MainWindow::initCodeEditor() {
    codeEditor = new CodeEditor(this);
    connect(codeEditor, SIGNAL(cursorPositionChanged()), this, SLOT(onCursorPositionChanged()));

    setCentralWidget(codeEditor);
}

void MainWindow::initStatusBar() {
    statusBar = new QStatusBar(this);
    setStatusBar(statusBar);

    cursorPosLabel = new QLabel("0:0");
    statusBar->addPermanentWidget(cursorPosLabel);
}

void MainWindow::initProcess() {
}

void MainWindow::onMenuFileOpen() {
    QString fileName = QFileDialog::getOpenFileName(this);
    if (fileName.isEmpty())
        return;
    QFile file(fileName);
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
        return;
    codeEditor->setPlainText(file.readAll());
    file.close();
    codeEditor->moveCursor(QTextCursor::Start);
    codeEditor->ensureCursorVisible();
}

void MainWindow::onMenuFileExit() {
    close();
}

void MainWindow::onMenuTaskRun() {
    QStringList arguments;
    arguments << "5";

    process->start("D:\\test_Console.exe", arguments);
}

void MainWindow::onMenuHelpQt() {
    QMessageBox::aboutQt(this);
}

void MainWindow::onCursorPositionChanged() {
    cursorPosLabel->setText(
        QString("%1:%2").arg(codeEditor->textCursor().blockNumber())
                        .arg(codeEditor->textCursor().positionInBlock()));

}

void MainWindow::onProcessStarted() {
}

void MainWindow::onProcessFinished(int exitCode, QProcess::ExitStatus exitStatus) {
}

void MainWindow::onReadStandardOutput() {
}
