#pragma once

#include <QPlainTextEdit>
#include <QCompleter>

#include "Highlighter.h"

class LineNumbersArea;

class CodeEditor : public QPlainTextEdit {
    Q_OBJECT
private:
    LineNumbersArea *lineNumbersArea;
    Highlighter     *syntaxHighlighter;
    QCompleter      *completer;
public:
    CodeEditor(QWidget *parent);
public:
    qint32 calcLNAreaWidth();
    void paintLNArea(QPaintEvent *e);
private:
    void resizeEvent(QResizeEvent* e);
    void keyPressEvent( QKeyEvent* event );
    QString textUnderCursor()const;
private slots:
    void onUpdateLNAreaWidth(qint32 numberOfLines);
    void onUpdateLNArea(const QRect &, qint32);
    void highlightCurrentLine();

    void onInsertCompletion(const QString &completion);
};

class LineNumbersArea : public QWidget {
    Q_OBJECT
private:
    CodeEditor  *parentEditor;
public:
    LineNumbersArea(CodeEditor *parent) : QWidget(parent), parentEditor(parent) {}
public:
    QSize sizeHint() const {
        return QSize(parentEditor->calcLNAreaWidth(), 0);
    }
private:
    void paintEvent(QPaintEvent *e) {
        parentEditor->paintLNArea(e);
    }
};
