#ifndef HIGHLIGHTER_H
#define HIGHLIGHTER_H

#include <QSyntaxHighlighter>
#include <QRegularExpression>

class CodeEditor;

class Highlighter : public QSyntaxHighlighter {
public:
    Highlighter(QTextDocument *parent);
private:
    struct HighlightingRule{
        QRegularExpression  pattern;
        QTextCharFormat     format;
    };
    QVector<HighlightingRule> highlightingRules;
public:
    void highlightBlock(const QString &text);
};

#endif // HIGHLIGHTER_H
