#pragma once

#include <QPlainTextEdit>

#include "Highlighter.h"

class LineNumbersArea;

class CodeEditor : public QPlainTextEdit {
    Q_OBJECT
private:
    LineNumbersArea *lineNumbersArea;
    Highlighter     *syntaxHighlighter;
public:
    CodeEditor(QWidget *parent);
public:
    qint32 calcLNAreaWidth();
    void paintLNArea(QPaintEvent *e);
private:
    void resizeEvent(QResizeEvent* e);
private slots:
    void onUpdateLNAreaWidth(qint32 numberOfLines);
    void onUpdateLNArea(const QRect &, qint32);
    void highlightCurrentLine();
};

class LineNumbersArea : public QWidget {
    Q_OBJECT
private:
    CodeEditor  *parentEditor;
public:
    LineNumbersArea(CodeEditor *parent) : QWidget(parent), parentEditor(parent) {}
public:
    QSize sizeHint() const {
        return QSize(parentEditor->calcLNAreaWidth(), 0);
    }
private:
    void paintEvent(QPaintEvent *e) {
        parentEditor->paintLNArea(e);
    }
};
