#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QTextEdit>
#include <QAction>
#include <QStatusBar>
#include <QLabel>

#include "Highlighter.h"

class MainWindow : public QMainWindow {
    Q_OBJECT
private:
    QAction        *actFileOpen;
    QAction        *actFileExit;
    QAction        *actHelpQt;
    QTextEdit      *codeEditor;
    Highlighter    *syntaxHighlighter;
    QStatusBar     *statusBar;
    QLabel         *cursorPosLabel;
public:
    MainWindow(QWidget *parent = NULL);
    ~MainWindow();
private:
    void initActions();
    void initMenu();
    void initCodeEditor();
    void initStatusBar();
private slots:
    void onMenuFileOpen();
    void onMenuFileExit();
    void onMenuHelpQt();
 };
#endif // MAINWINDOW_H
