#include "MainWindow.h"

#include <QMenu>
#include <QMenuBar>
#include <QMessageBox>

MainWindow::MainWindow(QWidget *parent) : QMainWindow(parent) {
    setWindowTitle("KRPO_Lab_0x06");
    resize(800, 600);

    initActions();
    initMenu();
    initStatusBar();
    initCodeEditor();
}

MainWindow::~MainWindow() {
}

void MainWindow::initActions() {
    // Menu "File"
    actFileOpen = new QAction("&Open", this);
    connect(actFileOpen, SIGNAL(triggered()), this, SLOT(onMenuFileOpen()));
    actFileExit = new QAction("&Exit", this);
    connect(actFileExit, SIGNAL(triggered()), this, SLOT(onMenuFileExit()));

    // Menu "Help"
    actHelpQt = new QAction("About &Qt", this);
    connect(actHelpQt, SIGNAL(triggered()), this, SLOT(onMenuHelpQt()));
}

void MainWindow::initMenu() {
    QMenu *menuFile = new QMenu("&File");
    menuFile->addAction(actFileOpen);
    menuFile->addSeparator();
    menuFile->addAction(actFileExit);

    QMenu *menuHelp = new QMenu("&Help");
    menuHelp->addAction(actHelpQt);

    menuBar()->addMenu(menuFile);
    menuBar()->addMenu(menuHelp);
}

void MainWindow::initCodeEditor() {
    codeEditor = new QTextEdit(this);

    QFont font;
    font.setFamily("Courier");
    font.setFixedPitch(true);
    font.setPointSize(10);
    codeEditor->setFont(font);

    syntaxHighlighter = new Highlighter(codeEditor->document());

    setCentralWidget(codeEditor);
}

void MainWindow::initStatusBar() {
    statusBar = new QStatusBar(this);
    setStatusBar(statusBar);

    cursorPosLabel = new QLabel("0:0");
    statusBar->addPermanentWidget(cursorPosLabel);
}

void MainWindow::onMenuFileOpen() {
}

void MainWindow::onMenuFileExit() {
    close();
}

void MainWindow::onMenuHelpQt() {
    QMessageBox::aboutQt(this);
}
