#include "Highlighter.h"

#include <QRegularExpressionMatchIterator>

Highlighter::Highlighter(QTextDocument *parent) : QSyntaxHighlighter(parent) {
}

void Highlighter::highlightBlock(const QString &text) {
    for (int i = 0; i < highlightingRules.size(); ++i) {
        HighlightingRule& rule = highlightingRules[i];
        QRegularExpressionMatchIterator matchIterator = rule.pattern.globalMatch(text);
        while (matchIterator.hasNext()) {
            QRegularExpressionMatch match = matchIterator.next();
            setFormat(match.capturedStart(), match.capturedLength(), rule.format);
        }
    }
}
