#include "MainWindow.h"

#include <QMenu>
#include <QMenuBar>
#include <QToolBar>
#include <QStatusBar>
#include <QDockWidget>

#include "DialogAbout.h"

MainWindow::MainWindow() : QMainWindow(NULL) {
    resize(QSize(400, 300));
    setWindowTitle("KRPO Laba #5");

    initActions();
    initMenuBar();
    initToolBar();
    initStatusBar();
    initLog();

    log->insertHtml("<b>info</b> The app has just started!<br>");

    painterWidget = new PainterWidget(this);
    setCentralWidget(painterWidget);
}

void MainWindow::initActions() {
    actFileOpen = new QAction(QIcon("/home/student/KRPO_Lab_0x05/task_01/open.png"), "&Open", this);
    connect(actFileOpen, SIGNAL(triggered()), this, SLOT(onMenuFileOpen()));
    actFileExit = new QAction(QIcon("/home/student/KRPO_Lab_0x05/task_01/exit.png"), "&Exit", this);
    connect(actFileExit, SIGNAL(triggered()), this, SLOT(onMenuFileExit()));
    actHelpAbout = new QAction(QIcon("/home/student/KRPO_Lab_0x05/task_01/about.png"), "&About", this);
    connect(actHelpAbout, SIGNAL(triggered()), this, SLOT(onMenuHelpAbout()));
}

void MainWindow::initMenuBar() {
    QMenu *menuFile = new QMenu("&File");
    menuFile->addAction(actFileOpen);
    menuFile->addSeparator();
    menuFile->addAction(actFileExit);

    QMenu *menuHelp = new QMenu("&Help");
    menuHelp->addAction(actHelpAbout);

    menuBar()->addMenu(menuFile);
    menuBar()->addMenu(menuHelp);
}

void MainWindow::initToolBar() {
    QToolBar *toolBar = new QToolBar(this);
    toolBar->addAction(actFileOpen);
    toolBar->addSeparator();
    toolBar->addAction(actFileExit);
    toolBar->addSeparator();
    toolBar->addAction(actHelpAbout);
    addToolBar(toolBar);
}

void MainWindow::initStatusBar() {
    QStatusBar *statusBar = new QStatusBar(this);
    setStatusBar(statusBar);
    statusBar->showMessage("Welcome to my prog!");
}

void MainWindow::initLog() {
    QDockWidget *dock = new QDockWidget("Log Window", this);
    log = new QTextEdit(this);
    dock->setWidget(log);
    dock->setMaximumHeight(150);
    addDockWidget(Qt::BottomDockWidgetArea, dock);
}

void MainWindow::onMenuFileOpen() {
    log->insertHtml("<b>Opening</b> file...");
}

void MainWindow::onMenuFileExit() {
    close();
}

void MainWindow::onMenuHelpAbout() {
    Dialog_About dlg(this);
    dlg.exec();
}

