#include "MainWindow.h"

#include <QMenu>
#include <QMenuBar>
#include <QToolBar>
#include <QStatusBar>

MainWindow::MainWindow() : QMainWindow(NULL) {
    resize(QSize(400, 200));
    setWindowTitle("");

    InitActions();
    InitMenuBar();
    InitToolBar();
    InitStatusBar();

    painterWidget = new PainterWidget(this);
    setCentralWidget(painterWidget);
}

void MainWindow::InitActions() {
    actFileExit = new QAction(QIcon("/home/student/KRPO_Lab_0x04/exit.png"), "&Exit", this);
    connect(actFileExit, SIGNAL(triggered()), this, SLOT(OnMenuFileExit()));
}

void MainWindow::InitMenuBar() {
    QMenu *menuFile = new QMenu("&File");
    menuFile->addAction(actFileExit);
    menuBar()->addMenu(menuFile);
}

void MainWindow::InitToolBar() {
    QToolBar *toolBar = new QToolBar(this);
    toolBar->addAction(actFileExit);
    addToolBar(toolBar);
}

void MainWindow::InitStatusBar() {
    QStatusBar *statusBar = new QStatusBar(this);
    setStatusBar(statusBar);
    statusBar->showMessage("Welcome to my prog!");
}

void MainWindow::OnMenuFileExit() {
    close();
}

