#include <dlfcn.h>
#include <iostream>

typedef void(*func_ptr)();

int main(int argc, char *argv[]) {
  void *handle = dlopen("library.so", RTLD_LAZY);
  if (!handle) {
    std::cout << "Can't load shared object" << std::endl;
    return 1;
  }
  func_ptr hello = (func_ptr)dlsym(handle, "print_message");
  if (!hello) {
    std::cout << "Can't load function" << std::endl;
    return 2;
  }

  hello();

  dlclose(handle);

  return 0;
}
