#include <X11/Xlib.h>
#include <stdlib.h>
#include <stdio.h>

int main() {
  Display *display = XOpenDisplay(NULL);
  if(!display) {
    printf("Can't open display.\n");
    return EXIT_FAILURE;
  };

  printf("Connection with X Server was established.\n");
  printf("\tConnection number: %d;\n", ConnectionNumber(display));
  printf("\tProtocol version: %d.%d;\n", ProtocolVersion(display), ProtocolRevision(display));
  printf("\tX Server vendor: %s;\n", ServerVendor(display));
  printf("\tX Server version: %d\n", VendorRelease(display));
  printf("\tConnection string: [%s];\n", DisplayString(display));
  printf("\tNumber of screens: %d;\n", ScreenCount(display));
  printf("\tDefault screen: %d;\n", DefaultScreen(display));

  XCloseDisplay(display);
  return EXIT_SUCCESS;
 };