#include <X11/Xlib.h>
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char *argv[]) {
  Display *display = NULL;
  int screen = -1;
  Window window;
  XEvent event;

  display=XOpenDisplay(NULL);
  if(!display) {
    printf("Cannot open display\n");
    return EXIT_FAILURE;
  }
   
  screen = DefaultScreen(display);

  window=XCreateSimpleWindow(display, RootWindow(display, screen), 10, 10, 200, 200, 1, BlackPixel(display, screen), WhitePixel(display, screen));
  XMapWindow(display, window);

  XSelectInput(display, window, ExposureMask);

  GC gc = XCreateGC(display, window, 0, NULL);
  
  XColor red, green;
  Colormap cmap = DefaultColormap(display, screen);
  Status rc = XAllocNamedColor(display, cmap, "red", &red, &red);
  if (!rc) {
    printf("'red' color allocation failure.\n");
    return EXIT_FAILURE;
  }
  rc = XAllocNamedColor(display, cmap, "green", &green, &green);
  if (!rc) {
    printf("'green' color allocation failure.\n");
    return EXIT_FAILURE;
  }
  XSetBackground(display, gc, green.pixel);
  
  for(;;) {
    XNextEvent(display, &event);

    if(event.type == Expose) {
      XClearWindow(display, window);
      XSetForeground(display, gc, red.pixel);
      XDrawLine(display, window, gc, 10, 60, 180, 20);
      XFillRectangle(display, window, gc, 20, 20, 100, 100);
      XSetForeground(display, gc, green.pixel);
      XDrawString(display, window, gc, 150, 150, "123", 3);
      XFlush(display);
    }
  }

  XFreeGC(display, gc);
  
  XDestroyWindow(display, window);
  XCloseDisplay(display);

  return EXIT_SUCCESS;
 }