#include <gtk/gtk.h>
#include <cairo.h>

gboolean onDraw(GtkWidget *widget, GdkEventExpose *event, gpointer data) {
  cairo_t *c = gdk_cairo_create(gtk_widget_get_window (widget));
  cairo_move_to(c, 30, 30);
  cairo_show_text(c, "Text");

  cairo_set_line_width(c, 1.0);
  cairo_set_source_rgb(c, 0, 0, 0);
  cairo_rectangle(c, 10, 10, 100, 100);
  cairo_stroke(c);

  cairo_destroy(c);

  g_print("draw\n");
  return TRUE;
}

int main(int argc, char *argv[]) {
  gtk_init(&argc, &argv);

  GtkWidget *window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_default_size(GTK_WINDOW(window), 800, 600);
  g_signal_connect(window, "destroy", G_CALLBACK(gtk_main_quit), NULL);

  GtkWidget *draw = gtk_drawing_area_new();
  gtk_container_add(GTK_CONTAINER(window), draw);
  g_signal_connect(G_OBJECT(draw), "expose-event", G_CALLBACK(onDraw), NULL);

  gtk_widget_show_all(window);

  gtk_main();

  return 0;
}
